function test_suite = testMakeDataFile %#ok<*STOUT>
%TESTMAKEDATAFILE Test method for making data files

initTestSuite;

function self = setup %#ok<*DEFNU>
self.data_file_names = {'start','member_points'};

% Delete the input file, if it exists
warning('off','MATLAB:DELETE:FileNotFound')
delete(self.data_file_names{:});
warning('on','MATLAB:DELETE:FileNotFound')

function testNoData(~)
obj = BertiniLab('variable_group',polysym('x'));

f = @() make_data_file(obj);
assertExceptionThrown(f,'MATLAB:minrhs')

function testNoFileName(~)
obj = BertiniLab('variable_group',polysym('x'));

f = @() make_data_file(obj,polysym(0));
assertExceptionThrown(f,'MATLAB:minrhs')

function testMinimalStart(self)
fname = self.data_file_names{1};

obj = BertiniLab('variable_group',polysym('x'));
s = obj.make_data_file(polysym(0),fname);
assertEqual(s,fname)

fid = fopen(fname);
n = fscanf(fid,'%d\n\n',1);
assertEqual(n,1)
x = fscanf(fid,'%d');
assertEqual(x,zeros(2,1))
fclose(fid);

function testMultiplePoints(self)
fname = self.data_file_names{2};

polysyms('x','y')
obj = BertiniLab('variable_group',[x y]);
data = polysym(eye(2));
s = obj.make_data_file(data,fname);
assertEqual(s,fname)
sols = obj.read_solutions(fname);
assertTrue(isequal(sols,polysym(eye(2))))

function teardown(self)
% Delete the input file, if it exists
warning('off','MATLAB:DELETE:FileNotFound')
delete(self.data_file_names{:});
warning('on','MATLAB:DELETE:FileNotFound')